Checklist MDR Annex XIV, Part A: Clinical Evaluation

| **Requirement**                                              | **Fulfilled?** | **Comment/Reference  (optional)** |
| ------------------------------------------------------------ | -------------- | --------------------------------- |
| 1) To plan, continuously  conduct and document a clinical  evaluation, manufacturers shall: |                |                                   |
| (a) establish and update  a clinical evaluation plan, which shall include at least:  — an identification of the  general safety and performance requirements that require support  from relevant clinical data; |                |                                   |
| — a specification of  the intended purpose of the device;    |                |                                   |
| — a clear specification of  intended target groups with clear indications and contra-indications; |                |                                   |
| — a detailed description of  intended clinical benefits to patients with relevant and specified  clinical outcome parameters; |                |                                   |
| — a specification of methods  to be used for examination of qualitative and quantitative aspects of  clinical safety with clear reference to the determination of  residual risks and side-effects; |                |                                   |
| — an indicative list and  specification of parameters to be used to determine, based on the state of  the art in medicine, the acceptability of the benefit-risk ratio for the  various indications and for the intended purpose or purposes of the  device; |                |                                   |
| — an indication how  benefit-risk issues relating to specific components such as use of  pharmaceutical, non-viable animal or human tissues, are to be  addressed; and |                |                                   |
| — a clinical development  plan indicating progression from exploratory investigations, such as  first-in-man studies, feasibility and pilot studies, to confirmatory  investigations, such as pivotal clinical investigations, and a PMCF as  referred to in Part B of this Annex with an indication of  milestones and a description of potential acceptance criteria; |                |                                   |
| (b) identify  available clinical data relevant to the device and  its intended purpose and any gaps in clinical  evidence through a systematic scientific literature review; |                |                                   |
| (c) appraise all  relevant clinical data by evaluating their suitability for  establishing the safety and performance of the device; |                |                                   |
| (d) generate, through  properly designed clinical investigations in accordance with the  clinical development plan, any new or additional clinical  data necessary to address outstanding issues; and |                |                                   |
| (e) analyse all  relevant clinical data in order to reach conclusions about the  safety and clinical performance of the device including its clinical  benefits. |                |                                   |
| 2) The clinical  evaluation shall be thorough and objective, and take into account both  favourable and unfavourable data. Its depth and extent shall be proportionate  and appropriate to the nature, classification, intended purpose and risks of  the device in question, as well as to the manufacturer's claims in  respect of the device. |                |                                   |
| 3) A clinical  evaluation may be based on clinical data relating to a device  for which equivalence to the device in question can be demonstrated. The  following technical, biological and clinical characteristics shall be taken  into consideration for the demonstration of equivalence: |                |                                   |
| — Technical: the device is  of similar design; is used under similar conditions of use; has similar  specifications and properties including physicochemical properties such as  intensity of energy, tensile strength, viscosity, surface characteristics,  wavelength and software algorithms; uses similar deployment methods, where  relevant; has similar principles of operation and  critical performance requirements;  — Biological: the device  uses the same materials or substances in contact with the same human tissues  or body fluids for a similar kind and duration of contact and similar release  characteristics of substances, including degradation products and leachables;  — Clinical: the device is  used for the same clinical condition or purpose, including similar severity  and stage of disease, at the same site in the body, in a similar population,  including as regards age, anatomy and physiology; has the same kind of user;  has similar relevant critical performance in view of the expected  clinical effect for a specific intended purpose. |                |                                   |
| The characteristics listed  in the first paragraph shall be similar to the extent that there would be no  clinically significant difference in the safety and clinical performance of  the device. Considerations of equivalence shall be based on proper scientific  justification. It shall be clearly demonstrated  that manufacturers have sufficient levels of access to the data  relating to devices with which they are claiming equivalence in order to  justify their claims of equivalence. |                |                                   |
| 4) The results of  the clinical evaluation and the clinical evidence on  which it is based shall be documented in a clinical  evaluation report which shall support the assessment of the conformity  of the device. |                |                                   |
| The clinical  evidence together with non-clinical data generated from  non-clinical testing methods and other relevant documentation shall allow  the manufacturer to demonstrate conformity with the general safety  and performance requirements and shall be part of the technical  documentation for the device in question. |                |                                   |
| Both favourable and  unfavourable data considered in the clinical evaluation shall be  included in the technical documentation. |                |                                   |